package cn.com.duiba.cloud.duiba.activity.service.api.param.task;

import cn.com.duiba.cloud.duiba.activity.service.api.enums.task.TaskStatusEnum;
import cn.com.duiba.cloud.duiba.activity.service.api.enums.task.TaskTypeEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Setter
@Getter
public class TaskPageParam extends PageRequest {
    private static final long serialVersionUID = 1L;

    /**
     * 应用Id
     */
    @NotNull
    private Long appId;

    private List<Long> taskIdList;
    private String taskTitle;
    /**
     * 任务类型
     *
     * @see TaskTypeEnum
     */
    private List<Integer> taskTypeList;

    /**
     * 任务状态
     *
     * @see TaskStatusEnum
     */
    private List<Integer> taskStatusList;

    /**
     * 关联的活动Id
     */
    private List<Long> relationIdList;
    /**
     * 非关联的活动Id
     */
    private List<Long> notRelationIdList;


    private Date start;
    private Date end;
}
