package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.sign;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: 郑建豪
 * @date: 2022/5/12 11:57
 * @description: 签到配置
 */
@Data
public class SignConfigVO implements Serializable {

    private static final long serialVersionUID = -2147456795652245543L;

    /**
     * 签到类型
     * 1，连续签到；2，累计签到
     */
    @NotNull(message="签到类型不能为空")
    private Integer signType;

    /**
     * 签到周期类型
     * 1，全周期；2，自然周；3，自然月；4，自定义周期
     */
    @NotNull(message = "签到周期类型不能为空")
    private Integer signPeriodType;

    /**
     * 自定义周期天数
     */
    private Integer customPeriodDays;

    /**
     * 签到奖励
     */
    private List<SignRewardVO> signRewards;

    /**
     * 是否开启补签
     * 0，不开启；1，开启
     */
    @NotNull(message="是否开启补签")
    private Integer openComplementSignStatus;

    /**
     * 补签需要积分数
     */
    private Long complementSignNeedCredits;

    /**
     * 补签次数上限
     */
    private Integer complementSignTimesLimit;
}
