package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @date:2022/3/25 14:24
 * @author:zhaozhanghai
 * @Description: 活动状态
 */
public enum ActivityStatusEnum {

//    0创建，1上架中，2下架，3终止
    CREATE(0,"创建"),
    UP(1,"上架"),
    DOWN(2,"下架"),
    STOP(3,"终止"),
    ;

    ActivityStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    private Integer status;
    private String desc;


    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static ActivityStatusEnum getByStatus(Integer status){
        ActivityStatusEnum activityStatusEnum = Arrays.asList(ActivityStatusEnum.values()).stream().filter(i -> Objects.equals(i.getStatus(), status)).findFirst().orElse(null);
        return activityStatusEnum;
    }
}
