package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/3/26 10:40
 * @author:zhaozhanghai
 * @Description:  奖品vo
 */
@Data
public class BasePrizeVo implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 规则code
     */
    private String ruleCode;

    /**
     * 规则名
     */
    private String ruleName;


    /**
     * 奖品名
     */
    private String prizeName;

    /**
     * 奖项商品ID,type为2的时候为道具ID
     */
    private Long itemId;

    /**
     * 奖项商品ID
     */
    private Long skuId;

    /**
     * 中奖概率
     */
    private String probability;

    /**
     * 概率类型：1，普通概率；2，替补必中，3.排行榜奖品
     */
    @Range(min = 1,max = 3,message ="概率类型有误" )
    private Integer probabilityType;

    /**
     * 奖品图片
     */
    private String icon;

    /**
     * 总库存
     */
    private Integer totalStock;

    /**
     * 已使用库存
     */
    private Integer usedStock;

    /**
     *奖品类型：1商品，2道具 3谢谢参与
     */
    private Integer prizeType;

    /**
     * 奖励数量
     */
    private Integer amount;

    /**
     * 中奖限制次数 0-不开启 大于0-限制次数
     */
    private Integer winningLimitTimes;

    /**
     * 保底抽奖次数 0-不开启 大于0-保底次数
     */
    private Integer guaranteedLotteryTimes;

    /**
     * 奖品信息展示于玩法皮肤上 0-不展示，1-展示
     */
    @Range(min = 0,max = 1,message = "奖品信息展示于玩法皮肤上类型错误")
    private Integer showPrize;

    /**
     * 分层出奖扩展字段
     */
    private List<BasePrizeVipExtVo> prizeVipExtVo;

    /**
     * 是否多奖项限制 0-不限制 1-限制
     */
    @Range(min = 0,max = 1,message = "是否多奖项限制类型错误")
    private Integer isMorePrize;

    /**
     * 是否是公共库存 0-不是 1-是
     */
    @Range(min = 0,max = 1,message = "是否是公共库存类型错误")
    private Integer isPublic;

    /**
     * 高分数
     */
    private Integer highScore;

    /**
     * 低分数
     */
    private Integer lowScore;

    /**
     * 前端的唯一id
     */
    private String momentId;

    /**
     * 答题获奖资格，需要答对的最小数量
     */
    private Integer leastNum;

    /**
     * 排序
     */
    private Long sort;



}
