package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityTemplateDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.param.ActivityTemplateQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @date:2022/3/24 11:50
 * @author:zhaozhanghai
 * @Description: 活动模板
 */
@AdvancedFeignClient
public interface RemoteActivityTemplateService {
    List<MallActivityTemplateDTO> list();


    /**
     * 保存一条记录
     */
    Long save(MallActivityTemplateDTO record) throws BizException;
    /**
     * 更新一条记录
     *
     * @param record
     */
    Integer updateById(MallActivityTemplateDTO record) throws BizException;

    PageResponse<MallActivityTemplateDTO> page(ActivityTemplateQueryParam param);

    MallActivityTemplateDTO getById(Long id);
    
    MallActivityTemplateDTO getByCode(String code);

    /**
     * 根据模板code批量获取
     * @param templateCodes
     * @return
     */
    List<MallActivityTemplateDTO> getByCodes(List<String> templateCodes);
}
