package cn.com.duiba.cloud.duiba.activity.service.api.utils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;
import java.util.Objects;

/**
 * 枚举校验
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/4/15
 */
public class EnumValidator implements ConstraintValidator<EnumValid, Object> {

    /**
     * 枚举类
     */
    private Class<?> clazz;
    /**
     * 校验属性
     */
    private String field;

    @Override
    public void initialize(EnumValid constraintAnnotation) {
        this.clazz = constraintAnnotation.target();
        this.field = constraintAnnotation.field();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (!clazz.isEnum()) {
            return false;
        }
        try {
            Object[] enumOptions = clazz.getEnumConstants();
            String getMethodName = "get" + upperCaseFirstChar(this.field);
            Method method = clazz.getMethod(getMethodName);
            for (Object opt : enumOptions) {
                Object code = method.invoke(opt);
                if (Objects.equals(code, value)) {
                    return true;
                }
            }
        } catch (Exception e) {
            return false;
        }
        return false;
    }

    private static String upperCaseFirstChar(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

}
