package cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityData;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述： 积分商城活动趋势数据
 *
 * @Auther: xiaotian
 * @Date: 2022/4/14 10:12
 * @Description:
 */
@Data
public class ActivityTrendDataDTO implements Serializable {
    private static final long serialVersionUID = 6718719617433014851L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 活动Id
     */
    private Long activityId;

    /**
     * 数据时间
     */
    private Date curDate;

    /**
     * 统计维度 1:新访客 2:老访客
     */
    private Integer itemScope;

    /**
     * 用户等级 最低为0，未知-1
     */
    private Integer consumerLevel;

    /**
     * 来源渠道 1:应用 2:公众号 3:小程序 未知：-1
     */
    private Integer channelSource;

    /**
     * 纬度类型：1:用户类型 2：等级 3:渠道 4:等级+渠道
     */
    private Integer dimType;

    /**
     * 活动访问次数
     */
    private Long visitPv;

    /**
     * 活动访问人数
     */
    private Long visitUv;

    /**
     * 参与活动次数
     */
    private Long joinPv;

    /**
     * 参数活动人数
     */
    private Long joinUv;

    /**
     * 消耗积分数
     */
    private Long costPoint;

    /**
     * 消耗积分人数
     */
    private Long costPointPerCount;

    /**
     * 分享活动次数
     */
    private Long sharePv;

    /**
     * 分享活动人数
     */
    private Long shareUv;

    /**
     * 邀请发起次数（总数）
     */
    private Long invitePv;

    /**
     * 邀请发起人数
     */
    private Long inviteUv;

    /**
     * 助力次数
     */
    private Long helpPv;

    /**
     * 助力人数
     */
    private Long helpUv;

    /**
     * 中奖人数
     */
    private Long winCount;

    /**
     * 领奖人数
     */
    private Long drawCount;

    /**
     * 总访问时长
     */
    private Long sumVisitTime;

    /**
     * 总游戏时长
     */
    private Long sumGameTime;

    /**
     * 分享页访问次数
     */
    private Long shareVisitPv;

    /**
     * 分享页访问人数
     */
    private Long shareVisitUv;

    /**
     * 有访问时长的uv
     */
    private Long sumVisitTimeUv;

    /**
     * 有游戏时长的uv
     */
    private Long sumGameTimeUv;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


}
