/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.activity.service.api.utils;

import cn.com.duiba.cloud.duiba.activity.service.api.utils.EnumValid;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class EnumValidator
implements ConstraintValidator<EnumValid, Object> {
    private Class<?> clazz;
    private String field;

    public void initialize(EnumValid constraintAnnotation) {
        this.clazz = constraintAnnotation.target();
        this.field = constraintAnnotation.field();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (!this.clazz.isEnum()) {
            return false;
        }
        try {
            ?[] enumOptions = this.clazz.getEnumConstants();
            String getMethodName = "get" + EnumValidator.upperCaseFirstChar(this.field);
            Method method = this.clazz.getMethod(getMethodName, new Class[0]);
            for (Object opt : enumOptions) {
                Object code = method.invoke(opt, new Object[0]);
                if (!Objects.equals(code, value)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static String upperCaseFirstChar(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

