package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.answer;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 选项配置
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/4/14
 */
@Data
public class OptionConfigVO implements Serializable {

    private static final long serialVersionUID = -2160828124168555806L;

    /**
     * 选项内容，不超过15个字符
     */
    @NotBlank(message = "选项内容不能为空")
    @Size(min = 1, max = 15, message = "选项内容长度为1～15个字符")
    private String content;

    /**
     * 选项图片
     */
    private String photo;

}
