package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.activityTask.ActivityTaskDto;

import java.util.List;

/**
 * @date:2022/4/14 11:50
 * @author:zhaozhanghai
 * @Description: 活动任务
 */
@AdvancedFeignClient
public interface RemoteActivityTaskService {


    /**
     * 获取该活动的配置的任务
     *
     * @param activityId
     * @return
     */
    List<ActivityTaskDto> activityTasks(Long activityId);


    /**
     * 尝试减去奖励的有效次数
     * @param activityId
     * @param customerId
     * @return
     */
    boolean tryMinusRewardCount(Long activityId,Long customerId);


    /**
     * 获取有效的奖励参与次数
     *
     * @param activityId
     * @param customerId
     * @return
     */
    Integer getValidRewardTimes(Long activityId, Long customerId);

}
