package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.dto;

import java.io.Serializable;

/**
 * @author zhengjianhao
 * @date 2022/4/24
 * @description
 */
public class PairDTO <K,V> implements Serializable {

	private volatile K key;

	private volatile V value;

	public PairDTO() {
		//do nothing
	}

	public PairDTO(K key, V value) {
		this.key = key;
		this.value = value;
	}

	public static <K, V> PairDTO<K, V> from(K key, V value) {
		return new PairDTO<>(key, value);
	}

	@Override
	@SuppressWarnings("unchecked")
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (obj instanceof PairDTO) {
			PairDTO<Object, Object> o = (PairDTO<Object, Object>) obj;

			if (key == null) {
				if (o.key != null) {
					return false;
				}
			} else if (!key.equals(o.key)) {
				return false;
			}

			if (value == null) {
				if (o.value != null) {
					return false;
				}
			} else if (!value.equals(o.value)) {
				return false;
			}

			return true;
		}

		return false;
	}

	public K getKey() {
		return key;
	}

	public V getValue() {
		return value;
	}

	@Override
	public int hashCode() {
		int hash = 0;

		hash = hash * 31 + (key == null ? 0 : key.hashCode());
		hash = hash * 31 + (value == null ? 0 : value.hashCode());

		return hash;
	}

	public void setKey(K key) {
		this.key = key;
	}

	public void setValue(V value) {
		this.value = value;
	}

	public int size() {
		return 2;
	}

	@Override
	public String toString() {
		return String.format("Pair[key=%s, value=%s]", key, value);
	}
}
