package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.task.TaskDto;
import cn.com.duiba.cloud.duiba.activity.service.api.param.task.TaskListParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.task.TaskPageParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.task.TaskParam;
import cn.com.duiba.cloud.duiba.activity.service.api.param.task.TaskSaveParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 任务系统相关接口(面向B端/管理端)
 */
@AdvancedFeignClient
public interface RemoteTaskBackendService {
    /**
     * 新增任务
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Long add(TaskSaveParam param) throws BizException;

    /**
     * 编辑任务
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean edit(TaskSaveParam param) throws BizException;


    /**
     * 任务启用、停用
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean changeStatus(TaskParam param) throws BizException;

    /**
     * 删除任务
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean remove(TaskParam param) throws BizException;

    /**
     * 翻页查询
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    PageResponse<TaskDto> page(TaskPageParam param) throws BizException;


    /**
     * 根据确定的id\code查询
     *
     * @param param
     *
     * @return
     */
    List<TaskDto> listTaskById(TaskListParam param) throws BizException;

    List<TaskDto> listTaskByCode(TaskListParam param) throws BizException;

}
