package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.UserPrizeDetailDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.UserPrizePageDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.UserPrizeReceiveDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.param.ReceiveRequest;
import cn.com.duiba.cloud.duiba.activity.service.api.param.UserPrizeListRequest;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 远程用户奖记录服务
 *
 * @author zouwx
 * @date 2022/04/02
 */
@AdvancedFeignClient
public interface RemoteUserPrizeRecordService {

    /**
     * 分页查询用户奖项记录页面
     *
     * @param userPrizeListRequest 用户奖列表请求
     * @return {@link PageResponse}<{@link UserPrizePageDTO}>
     * @throws BizException 业务异常
     */
    PageResponse<UserPrizePageDTO> findUserPrizeRecordPage(UserPrizeListRequest userPrizeListRequest) throws BizException;

    /**
     * 查询用户领取详情
     *
     * @param userPrizeId 用户奖id
     * @return {@link UserPrizeDetailDTO}
     * @throws BizException 业务异常
     */
    UserPrizeDetailDTO findUserPrizeDetail(Long userPrizeId) throws BizException;

    /**
     * 收到
     * 领奖
     *
     * @param receiveRequest 接收请求
     * @return {@link UserPrizeReceiveDTO}
     * @throws BizException 业务异常
     */
    UserPrizeReceiveDTO receive(ReceiveRequest receiveRequest) throws BizException;
}
