package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.param.task.TaskRecordParam;

import javax.validation.Valid;

/**
 * 任务系统相关接口(面向C端/用户端)
 */
@AdvancedFeignClient
public interface RemoteTaskService {

    /**
     * 记录用户参与任务，包含（任务校验、次数校验、）
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Long record(@Valid TaskRecordParam param) throws BizException;

    
    /**
     * 给用户发奖（主动领取，自动发奖）
     *
     * @return
     */
    Boolean reward(@Valid TaskUserParam param) throws BizException;


    /**
     * 统计用户是否有待领取的奖励
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Long countWaitReward(@Valid TaskUserParam param) throws BizException;
}
