/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.config.cache;

import cn.hutool.core.io.IoUtil;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class Hessian2SerializationRedisSerializer
implements RedisSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(Hessian2SerializationRedisSerializer.class);
    public static final int FLAG_COMPRESSED = 1;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    public static final int DEFAULT_MAX_SIZE = 0x100000;
    private int compressionThreshold = 1024;
    private int maxSize = 0x100000;
    private String compressMode = "gzip";
    private static int COMPRESS_RATIO = 8;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (bytes.length == 1) {
            throw new SerializationException("Cannot deserialize, bytes.length must be > 1, maybe this key is used by other redis client\uff0cor you use RedisTemplate to incr/decr");
        }
        try {
            byte flags = bytes[0];
            byte[] data = Arrays.copyOfRange(bytes, 1, bytes.length);
            if ((flags & 1) != 0) {
                data = this.decompress(data);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Hessian2Input hessian2Input = new Hessian2Input((InputStream)in);
            return hessian2Input.readObject();
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize, maybe this key is used by other redis client", (Throwable)ex);
        }
    }

    public byte[] serialize(Object object) {
        if (object == null) {
            return EMPTY_ARRAY;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Hessian2Output hessian2Output = new Hessian2Output((OutputStream)out);
            hessian2Output.writeObject(object);
            hessian2Output.flush();
            byte[] data = out.toByteArray();
            int flags = 0;
            if (data.length > this.compressionThreshold) {
                byte[] compressed = this.compress(data);
                if (compressed.length < data.length) {
                    if (log.isDebugEnabled()) {
                        log.debug("Compressed " + object.getClass().getName() + " from " + data.length + " to " + compressed.length);
                    }
                    data = compressed;
                    flags = (byte)(flags | 1);
                } else if (log.isDebugEnabled()) {
                    log.debug("Compression increased the size of " + object.getClass().getName() + " from " + data.length + " to " + compressed.length);
                }
            }
            if (data.length > this.maxSize) {
                throw new IllegalArgumentException("Cannot cache data larger than " + this.maxSize + " byte (you tried to cache a " + data.length + " byte object)");
            }
            out = new ByteArrayOutputStream();
            out.write(flags);
            out.write(data);
            return out.toByteArray();
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot serialize", (Throwable)ex);
        }
    }

    public final byte[] compress(byte[] in) {
        if ("zip".equals(this.compressMode)) {
            return this.zipCompress(in);
        }
        return this.gzipCompress(in);
    }

    private byte[] zipCompress(byte[] in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(in.length);
        DeflaterOutputStream os = new DeflaterOutputStream(baos);
        try {
            os.write(in);
            os.finish();
            IoUtil.close((Closeable)os);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception compressing data", e);
        }
        finally {
            IoUtil.close((Closeable)baos);
        }
        return baos.toByteArray();
    }

    /*
     * Exception decompiling
     */
    private byte[] gzipCompress(byte[] in) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected byte[] decompress(byte[] in) {
        if ("zip".equals(this.compressMode)) {
            return this.zipDecompress(in);
        }
        return this.gzipDecompress(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zipDecompress(byte[] in) {
        int size = in.length * COMPRESS_RATIO;
        ByteArrayInputStream bais = new ByteArrayInputStream(in);
        InflaterInputStream is = new InflaterInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        try {
            int len;
            byte[] uncompressMessage = new byte[size];
            while ((len = is.read(uncompressMessage)) > 0) {
                baos.write(uncompressMessage, 0, len);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error("Failed to decompress data", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
            IOUtils.closeQuietly((Closeable)bais);
            IOUtils.closeQuietly((Closeable)baos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gzipDecompress(byte[] in) {
        ByteArrayOutputStream bos = null;
        if (in != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            bos = new ByteArrayOutputStream();
            try (GZIPInputStream gis = new GZIPInputStream(bis);){
                byte[] buf = new byte[16384];
                int r = -1;
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                log.error("Failed to decompress data", (Throwable)e);
                bos = null;
            }
            finally {
                IOUtils.closeQuietly((Closeable)bis);
            }
        }
        return bos == null ? null : bos.toByteArray();
    }
}

