/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.utils;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

public class NumberTool {
    public static Long tryParseLong(String string) {
        return NumberTool.tryParseLong(string, null);
    }

    public static Long tryParseLong(String str, Long defaultValue) {
        Long value;
        if (StrUtil.isBlank((CharSequence)str)) {
            return defaultValue;
        }
        try {
            value = Long.parseLong(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static String tryValueOf(Object obj) {
        return Objects.toString(obj, null);
    }

    public static void main(String[] args) {
        System.out.println(Objects.equals("0.01", NumberTool.fen2yuan(1L)));
        System.out.println(Objects.equals("0.05", NumberTool.fen2yuan(5L)));
        System.out.println(Objects.equals("5.50", NumberTool.fen2yuan(550L)));
        System.out.println(Objects.equals("-0.01", NumberTool.fen2yuan(-1L)));
        System.out.println(Objects.equals("0.00", NumberTool.fen2yuan(0L)));
        System.out.println(Objects.equals("1.00", NumberTool.fen2yuan(100L)));
        System.out.println(Objects.equals("1.09", NumberTool.fen2yuan(109L)));
        System.out.println(Objects.equals("10.09", NumberTool.fen2yuan(1009L)));
        System.out.println(Objects.equals(NumberTool.yuan2fen("0.01"), 1L));
        System.out.println(Objects.equals(NumberTool.yuan2fen("-0.01"), -1L));
        System.out.println(Objects.equals(NumberTool.yuan2fen("0.00"), 0L));
        System.out.println(Objects.equals(NumberTool.yuan2fen("1.00"), 100L));
        System.out.println(Objects.equals(NumberTool.yuan2fen("1.09"), 109L));
        System.out.println(Objects.equals(NumberTool.yuan2fen("10.09"), 1009L));
    }

    public static String fen2yuan(Long fen) {
        return new BigDecimal(fen).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP).toString();
    }

    public static Long yuan2fen(String yuan) {
        return new BigDecimal(yuan).multiply(new BigDecimal(100)).longValue();
    }

    public static String calculateRate(long count, long sum, int pointNum) {
        return NumberUtil.roundStr((double)((double)count * 100.0 / (double)sum), (int)pointNum, (RoundingMode)RoundingMode.HALF_UP);
    }
}

