package cn.com.duiba.cloud.biz.tool.config.cache;

import com.alibaba.fastjson2.support.spring.data.redis.GenericFastJsonRedisSerializer;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.StringRedisSerializer;

import javax.annotation.Resource;
import java.util.Arrays;

/**
 * spring cache自动装配
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/6 2:28 下午
 * @since 0.0.8
 **/
@EnableCaching
@Configuration(proxyBeanMethods = false)
@AutoConfiguration(after = {cn.com.duiba.cloud.biz.tool.config.redis.RedisAutoConfiguration.class
        , RedisAutoConfiguration.class, RedissonAutoConfiguration.class})
@ConditionalOnClass(RedisOperations.class)
@EnableConfigurationProperties(CacheProperties.class)
public class CacheAutoConfiguration extends CachingConfigurerSupport {
    @Resource
    private RedisConnectionFactory factory;
    @Resource
    private CacheProperties cacheProperties;

    @Bean
    @Override
    public CacheManager cacheManager() {
        // Assert.notNull(PropertiesUtil.getInstance().getProperty("spring.application.name"), "应用名不能为空");
        RedisCacheConfiguration defaultConfig = RedisCacheConfiguration.defaultCacheConfig()
                /*.computePrefixWith(cacheName -> cacheProperties.getPrefixName().concat(":").concat(cacheName).concat(
                        ":"))*/
                .disableCachingNullValues()
                .serializeKeysWith(RedisSerializationContext
                        .SerializationPair
                        .fromSerializer(new StringRedisSerializer()))
                .serializeValuesWith(RedisSerializationContext
                        .SerializationPair
                        .fromSerializer(new GenericFastJsonRedisSerializer()));
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter(factory);
        RedisCacheManagerConfiguration redisCacheManagerConfiguration =
                new RedisCacheManagerConfiguration(redisCacheWriter, defaultConfig);
        redisCacheManagerConfiguration.setTransactionAware(true);
        return redisCacheManagerConfiguration;
    }

    @Bean(name = "classKeyGenerator")
    public KeyGenerator classKeyGenerator() {
        return (target, method, params) -> target.getClass().getName() + "|" +
                method.getName() + "|" +
                Arrays.asList(params);
    }

    @Bean(name = "argsKeyGenerator")
    public KeyGenerator argsKeyGenerator() {
        return (target, method, params) -> Arrays.asList(params).toString();
    }
}