package cn.com.duiba.cloud.biz.tool.config.datasource;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.provider.AbstractDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.google.common.collect.Maps;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.util.Map;

/**
 * 动态切换数据源集成shardingSphere自动装配
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-26 16:41
 * @since 0.1.0
 **/
@Configuration(proxyBeanMethods = false)
@ConditionalOnClass({DynamicRoutingDataSource.class, ShardingSphereDataSource.class})
@AutoConfigureBefore(DynamicDataSourceAutoConfiguration.class)
public class DuibaDynamicDataSourceAutoConfiguration {
    /**
     * 分表数据源名称
     */
    public static final String SHARDING_DATA_SOURCE_NAME = "sharding";

    @Resource
    private DynamicDataSourceProperties properties;
    @Resource
    private ShardingSphereDataSource shardingSphereDataSource;

    @Bean
    @ConditionalOnClass({DynamicRoutingDataSource.class, ShardingSphereDataSource.class})
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        return new AbstractDataSourceProvider() {
            @Override
            public Map<String, DataSource> loadDataSources() {
                Map<String, DataSource> dataSourceMap = Maps.newHashMap();
                dataSourceMap.put(SHARDING_DATA_SOURCE_NAME, shardingSphereDataSource);
                // 将meta的数据源也加入管理
                Map<String, ShardingSphereMetaData> metaDataMap = shardingSphereDataSource.getContextManager()
                        .getMetaDataContexts().getMetaDataMap();
                for (Map.Entry<String, ShardingSphereMetaData> entry : metaDataMap.entrySet()) {
                    dataSourceMap.putAll(entry.getValue().getResource().getDataSources());
                }
                return dataSourceMap;
            }
        };
    }

    @Bean
    @Primary
    public DataSource dataSource() {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(properties.getPrimary());
        dataSource.setStrict(properties.getStrict());
        dataSource.setStrategy(properties.getStrategy());
        dataSource.setP6spy(properties.getP6spy());
        dataSource.setSeata(properties.getSeata());
        return dataSource;
    }
}
