package cn.com.duiba.cloud.biz.tool.config.datasource;

import cn.com.duiba.cloud.biz.tool.event.MainContextRefreshedEvent;
import lombok.extern.slf4j.Slf4j;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.core.database.parser.DatabaseTypedSQLParserFacadeRegistry;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorFactory;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorRule;
import org.apache.shardingsphere.sql.parser.spi.DatabaseTypedSQLParserFacade;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

/**
 * sharding数据源预热，解决第一次sql执行慢的问题
 * <p>
 * 出现问题的可能：<br>
 *     <ul>
 *         <li>和java本身解释编译有些关系</li>
 *         <li>sharding内部应该有路由缓存，具体没研究过</li>
 *         <li>还是要排除mybatis可能有缓存的原因</li>
 *     </ul>
 * </p>
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.8
 **/
@Slf4j
@Configuration(proxyBeanMethods = false)
@ConditionalOnClass(ShardingSphereDataSource.class)
public class ShardingPreHeatConfiguration {
    @EventListener(MainContextRefreshedEvent.class)
    public void freshSharding() {
        log.info("sharding data source preHeat--------------------------------------------------------");
        String databaseType = "MySQL";
        String sql = "select 'X'";
        DatabaseTypedSQLParserFacade sqlParserFacade = DatabaseTypedSQLParserFacadeRegistry.getFacade(databaseType);
        SQLParser sqlParser = SQLParserFactory.newInstance(sql, sqlParserFacade.getLexerClass(),
                sqlParserFacade.getParserClass(), true);
        ParseASTNode execute = (ParseASTNode) sqlParser.parse();
        ParseTree parseTree = execute.getRootNode();
        SQLVisitorFactory.newInstance(databaseType, "STATEMENT", SQLVisitorRule.valueOf(
                parseTree.getClass()), null);
    }
}