package cn.com.duiba.cloud.biz.tool.event;

import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;

/**
 * 主容器刷新事件。
 * <br/>
 * 1.会在主容器所有bean初始化完成之后，且在主容器发出ContextRefreshedEvent之后发出。
 * 2.会在FinalContextRefreshedEvent之前发出
 * <p>
 * 由于子容器的ContextRefreshedEvent也会传给主容器，导致事件会被处理多次，故添加本事件。本事件只会由主容器处理，且只处理一次。
 * 可以在接收到此事件后做一些初始化动作（可以用于在容器彻底启动并暴露dubbo、spring-cloud服务前做些初始化动作）
 *
 * @author zhoujunquan@duiba.com.cn
 */
public class MainContextRefreshedEvent extends ApplicationContextEvent {

    public MainContextRefreshedEvent(ApplicationContext source) {
        super(source);
    }
}
