package cn.com.duiba.cloud.biz.tool.exception;

import cn.com.duiba.cloud.biz.tool.message.BaseError;
import cn.com.duiba.cloud.biz.tool.model.JsonResult;
import cn.hutool.core.io.IoUtil;
import cn.hutool.http.ContentType;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.StandardCharsets;

/**
 * WebMvc全局异常处理
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.12
 **/
@Deprecated
@Slf4j
@Order(Ordered.LOWEST_PRECEDENCE - 11)
public class WebMvcExceptionHandler implements HandlerExceptionResolver {
    @Override
    public ModelAndView resolveException(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response
            , Object handler, @NonNull Exception e) {
        response.setContentType(ContentType.build(ContentType.JSON, StandardCharsets.UTF_8));
        try {
            if (e instanceof BizException) {
                return bizExceptionHandler(e, response);
            }
            if (e instanceof UndeclaredThrowableException) {
                if (e.getCause() instanceof BizException) {
                    return bizExceptionHandler((BizException) e.getCause(), response);
                } else {
                    return globalExceptionHandler(e, request, response);
                }
            }
            if (e instanceof MethodArgumentNotValidException) {
                return methodArgumentNotValidExceptionHandler(e, response);
            }
            if (e instanceof IllegalArgumentException) {
                return illegalArgumentExceptionHandler(e, response);
            }
            return globalExceptionHandler(e, request, response);
        } catch (IOException ex) {
            throw new RuntimeException(e.getMessage(), ex);
        }
    }

    private ModelAndView bizExceptionHandler(Exception e, HttpServletResponse response) throws IOException {
        log.warn("BizException [{}]", e.getMessage(), e);
        ioWrite(response.getOutputStream(), JSON.toJSONString(
                JsonResult.fail(((BizException) e).getCode(), e.getMessage())
                , JSONWriter.Feature.WriteMapNullValue));
        return new ModelAndView();
    }

    private ModelAndView methodArgumentNotValidExceptionHandler(Exception e, HttpServletResponse response)
            throws IOException {
        BindingResult bindResult = null;
        if (e instanceof BindException) {
            bindResult = ((BindException) e).getBindingResult();
        } else if (e instanceof MethodArgumentNotValidException) {
            bindResult = ((MethodArgumentNotValidException) e).getBindingResult();
        }
        String message = "参数错误";
        if (bindResult != null && bindResult.hasErrors()) {
            ObjectError objectError = bindResult.getAllErrors().get(0);
            message = objectError.getDefaultMessage();
        }
        ioWrite(response.getOutputStream(), JSON.toJSONString(
                JsonResult.fail(BaseError.PARAM_ERROR.getCode(), message)
                , JSONWriter.Feature.WriteMapNullValue));
        return new ModelAndView();
    }

    private ModelAndView illegalArgumentExceptionHandler(Exception e, HttpServletResponse response) throws IOException {
        log.error("IllegalArgumentException", e);
        ioWrite(response.getOutputStream(), JSON.toJSONString(JsonResult.fail(e.getMessage())
                , JSONWriter.Feature.WriteMapNullValue));
        return new ModelAndView();
    }

    private ModelAndView globalExceptionHandler(Exception e, HttpServletRequest request
            , HttpServletResponse response) throws IOException {
        String message = e.getMessage();
        if (e instanceof InvocationTargetException && message == null) {
            message = ((InvocationTargetException) e).getTargetException().getMessage();
        }
        log.error("Exception [{} -> {}]:", request.getRequestURI(), message, e);
        ioWrite(response.getOutputStream(), JSON.toJSONString(JsonResult.fail(BaseError.SYSTEM_ERROR.getMsg())
                , JSONWriter.Feature.WriteMapNullValue));
        return new ModelAndView();
    }

    private void ioWrite(ServletOutputStream outputStream, String msg) {
        IoUtil.writeUtf8(outputStream, true, msg);
    }
}