package cn.com.duiba.cloud.biz.tool.utils;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

/**
 * 为了与NumberUtil区分
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/12/7 17:00
 */
public class NumberTool {

    /**
     * String转Long
     *
     * @param string 字符串
     * @return 转换后的Long值
     */
    public static Long tryParseLong(String string) {
        return tryParseLong(string, null);
    }

    /**
     * String转Long
     *
     * @param str          字符串
     * @param defaultValue 默认值
     * @return 转换后的Long值
     */
    public static Long tryParseLong(String str, Long defaultValue) {
        if (StrUtil.isBlank(str)) {
            return defaultValue;
        }
        Long value;
        try {
            value = Long.parseLong(str.trim());
        } catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    /**
     * 对象转字符串
     * 当 NULL 时返回 NULL，而不是"null"
     *
     * @param obj 对象
     * @return 转换后的字符串值
     */
    public static String tryValueOf(Object obj) {
        return Objects.toString(obj, null);
    }

    public static void main(String[] args) {
        System.out.println(Objects.equals("0.01", fen2yuan(1L)));
        System.out.println(Objects.equals("0.05", fen2yuan(5L)));
        System.out.println(Objects.equals("5.50", fen2yuan(550L)));
        System.out.println(Objects.equals("-0.01", fen2yuan(-1L)));
        System.out.println(Objects.equals("0.00", fen2yuan(0L)));
        System.out.println(Objects.equals("1.00", fen2yuan(100L)));
        System.out.println(Objects.equals("1.09", fen2yuan(109L)));
        System.out.println(Objects.equals("10.09", fen2yuan(1009L)));

        System.out.println(Objects.equals(yuan2fen("0.01"), (1L)));
        System.out.println(Objects.equals(yuan2fen("-0.01"), (-1L)));
        System.out.println(Objects.equals(yuan2fen("0.00"), (0L)));
        System.out.println(Objects.equals(yuan2fen("1.00"), (100L)));
        System.out.println(Objects.equals(yuan2fen("1.09"), (109L)));
        System.out.println(Objects.equals(yuan2fen("10.09"), (1009L)));
    }

    /**
     * 分转元（除以100）<br>
     * 前端展示用，不参与计算
     *
     * @param fen 分值
     */
    public static String fen2yuan(Long fen) {
        return new BigDecimal(fen).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP).toString();
    }

    /**
     * 元转分（乘以100）<br>
     * 前端展示用，不参与计算
     *
     * @param yuan 元值
     */
    public static Long yuan2fen(String yuan) {
        return new BigDecimal(yuan).multiply(new BigDecimal(100)).longValue();
    }


    /**
     * <pre>
     * 计算百分比，展示后面直接拼上%就行了
     * 0/100=0.00
     * 1/100=1.00
     * 1/1000=0.10
     * 1/10000=0.01
     * 5/100000=0.01
     * 99/100000=0.10
     * </pre>
     *
     * @param sum      总数
     * @param count    部分数
     * @param pointNum 小数位
     * @return 百分比，含2位小数，
     */
    public static String calculateRate(long count, long sum, int pointNum) {
        return NumberUtil.roundStr((double) count * 100 / sum, pointNum, RoundingMode.HALF_UP);
    }
}
