/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.config.cache;

import cn.com.duiba.cloud.biz.tool.config.cache.RedisCacheManagerConfiguration;
import cn.com.duiba.cloud.biz.tool.config.redis.RedisAutoConfiguration;
import com.alibaba.fastjson2.support.spring.data.redis.GenericFastJsonRedisSerializer;
import java.util.Arrays;
import javax.annotation.Resource;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@EnableCaching
@Configuration(proxyBeanMethods=false)
@AutoConfiguration(after={RedisAutoConfiguration.class, org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration.class, RedissonAutoConfiguration.class})
@ConditionalOnClass(value={RedisOperations.class})
public class CacheAutoConfiguration
extends CachingConfigurerSupport {
    @Resource
    private RedisConnectionFactory factory;

    @Bean
    public CacheManager cacheManager() {
        RedisCacheConfiguration defaultConfig = RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericFastJsonRedisSerializer()));
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)this.factory);
        RedisCacheManagerConfiguration redisCacheManagerConfiguration = new RedisCacheManagerConfiguration(redisCacheWriter, defaultConfig);
        redisCacheManagerConfiguration.setTransactionAware(true);
        return redisCacheManagerConfiguration;
    }

    @Bean(name={"classKeyGenerator"})
    public KeyGenerator classKeyGenerator() {
        return (target, method, params) -> target.getClass().getName() + "|" + method.getName() + "|" + Arrays.asList(params);
    }

    @Bean(name={"argsKeyGenerator"})
    public KeyGenerator argsKeyGenerator() {
        return (target, method, params) -> Arrays.asList(params).toString();
    }
}

