/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.config.cache;

import cn.com.duiba.cloud.biz.tool.constants.ExpireConstant;
import cn.hutool.core.collection.ListUtil;
import java.util.ArrayList;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class RedisCacheManagerConfiguration
extends RedisCacheManager {
    public RedisCacheManagerConfiguration(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration);
    }

    @NonNull
    protected RedisCache createRedisCache(@NonNull String name, RedisCacheConfiguration cacheConfig) {
        ArrayList nameList = ListUtil.toList((Object[])StringUtils.delimitedListToStringArray((String)name, (String)"#"));
        ExpireConstant.ExpireEnum ttl = ExpireConstant.ExpireEnum.findByFirstNameFormat(nameList.stream());
        cacheConfig = cacheConfig.entryTtl(ttl.getExpire());
        nameList.remove(ttl.name());
        String cacheName = String.join((CharSequence)"#", nameList);
        return super.createRedisCache(cacheName, cacheConfig);
    }
}

