/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.config.datasource;

import cn.com.duiba.cloud.biz.tool.config.datasource.DuibaDataSourceMonitor;
import cn.com.duiba.cloud.biz.tool.event.MainContextRefreshedEvent;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={DataSource.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class DuibaDataSourceAutoConfiguration {

    @Configuration
    public static class DuibaDataSourceMonitorAutoConfiguration {
        @EventListener(value={MainContextRefreshedEvent.class})
        public void initListener(MainContextRefreshedEvent event) {
            ApplicationContext applicationContext = event.getApplicationContext();
            new DuibaDataSourceMonitor().startRun(applicationContext);
        }
    }
}

