/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.utils;

import cn.com.duiba.cloud.biz.tool.exception.BizException;
import cn.com.duiba.cloud.biz.tool.message.BaseError;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.commons.lang3.StringUtils;

public class ValidatorUtil {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> void validate(T obj, Class<?> groups) throws BizException {
        Optional<String> errorMsg = Optional.ofNullable(VALIDATOR.validate(obj, new Class[]{Objects.isNull(groups) ? Default.class : groups})).map(set -> set.stream().filter(e -> Objects.nonNull(e) && Objects.nonNull(e.getPropertyPath())).map(e -> e.getPropertyPath().toString().concat(e.getMessage())).collect(Collectors.joining(","))).filter(StringUtils::isNotBlank);
        if (errorMsg.isPresent()) {
            throw new BizException(MessageFormat.format("{0}[{1}]", BaseError.PARAM_ERROR.getMsg(), errorMsg.get())).withCode(BaseError.PARAM_ERROR.getCode());
        }
    }
}

