package cn.com.duiba.cloud.biz.tool.config.cache;

import cn.com.duibaboot.ext.autoconfigure.data.redis.DuibaRedisCondition;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisProperties;
import cn.hutool.core.util.StrUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * redisson自动装配
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-03-09 18:46
 * @since 0.0.11
 **/
@Configuration(proxyBeanMethods = false)
@ConditionalOnClass(RedissonClient.class)
@AutoConfigureAfter(RedisAutoConfiguration.class)
@EnableConfigurationProperties(RedisProperties.class)
public class RedissonConfiguration {
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";

    @Resource
    private RedisProperties redisProperties;

    @Bean
    @Conditional(DuibaRedisCondition.class)
    @ConditionalOnMissingBean(RedissonClient.class)
    public RedissonClient redissonClient() {
        Config config = new Config();
        config.useSingleServer().setAddress(REDIS_PROTOCOL_PREFIX + redisProperties.getHost() + ":"
                + redisProperties.getPort()).setPassword(StrUtil.isEmpty(redisProperties.getPassword()) ?
                null : redisProperties.getPassword());
        return Redisson.create(config);
    }
}
