package cn.com.duiba.cloud.biz.tool.utils;

import org.apache.commons.lang3.tuple.Triple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 描述：list 工具类
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/4/20 10:23
 */
public class ListTool {

    @FunctionalInterface
    interface KeyGenerator<T> {
        String key(T t);
    }


    /**
     * 通过与已有对象进行比较，得出要新建的、要更新的、要删除的
     *
     * @param existList    已存在的对象
     * @param list         本次修改的对象
     * @param keyGenerator 对象唯一标识方法
     * @param <T>          泛型
     *
     * @return left=needCreate mid=needUpdate right=needDelete
     */
    public static <T> Triple<List<T>, List<T>, List<T>> compare(List<T> existList,
                                                                List<T> list,
                                                                KeyGenerator<T> keyGenerator) {
        Map<String, T> existSkuMap = existList.stream().collect(Collectors.toMap(keyGenerator::key, Function.identity()));

        List<T> needUpdate = new ArrayList<>();
        List<T> needCreate = new ArrayList<>();
        Set<String> validIds = new HashSet<>();
        for (T t : list) {
            String key = keyGenerator.key(t);
            T exist = existSkuMap.get(key);
            if (exist == null) {
                needCreate.add(t);
            } else {
                needUpdate.add(t);
                validIds.add(key);
            }
        }
        List<T> needDelete = new ArrayList<>();
        for (Map.Entry<String, T> entry : existSkuMap.entrySet()) {
            if (!validIds.contains(entry.getKey())) {
                needDelete.add(entry.getValue());
            }
        }

        return Triple.of(needCreate, needUpdate, needDelete);
    }

}
