package cn.com.duiba.cloud.biz.tool.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.message.BaseError;
import org.apache.commons.lang3.StringUtils;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * JSR校验器
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/3/30 10:34
 */
public class ValidatorUtil {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();

    /**
     * 参数校验
     *
     * @param obj    obj
     * @param groups groups
     * @throws BizException 业务异常
     */
    public static <T> void validate(T obj, Class<?> groups) throws BizException {
        Optional<String> errorMsg = Optional.ofNullable(
                        VALIDATOR.validate(obj, Objects.isNull(groups) ? Default.class : groups)
                ).map(set -> set.stream()
                        .filter(e -> Objects.nonNull(e) && Objects.nonNull(e.getPropertyPath()))
                        .map(e -> e.getPropertyPath().toString().concat(e.getMessage()))
                        .collect(Collectors.joining(",")))
                .filter(StringUtils::isNotBlank);
        if (errorMsg.isPresent()) {
            throw new BizException(MessageFormat.format("{0}[{1}]", BaseError.PARAM_ERROR.getMsg()
                    , errorMsg.get())).withCode(BaseError.PARAM_ERROR.getCode());
        }
    }
}
