/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.aop.validation;

import cn.com.duiba.boot.exception.BizException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ValidationAspect {
    private static final Validator BEAN_VALIDATOR;
    private static final ExecutableValidator METHOD_VALIDATOR;

    @Pointcut(value="@within(cn.com.duiba.cloud.biz.tool.aop.validation.Validation) || @annotation(cn.com.duiba.cloud.biz.tool.aop.validation.Validation)")
    public void validate() {
    }

    @Before(value="validate()")
    public void before(JoinPoint point) throws BizException {
        Object target = point.getThis();
        Object[] args = point.getArgs();
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        Set<ConstraintViolation<Object>> validResult = this.validMethodParams(target, method, args);
        Object[] objectArray = validResult.iterator();
        if (objectArray.hasNext()) {
            ConstraintViolation<Object> objectConstraintViolation = objectArray.next();
            throw new BizException(objectConstraintViolation.getMessage());
        }
        for (Object bean : args) {
            Iterator<ConstraintViolation<Object>> iterator;
            if (null == bean || !(iterator = (validResult = this.validBeanParams(bean)).iterator()).hasNext()) continue;
            ConstraintViolation<Object> objectConstraintViolation = iterator.next();
            throw new BizException(objectConstraintViolation.getMessage());
        }
    }

    private <T> Set<ConstraintViolation<T>> validMethodParams(T obj, Method method, Object[] params) {
        return METHOD_VALIDATOR.validateParameters(obj, method, params, new Class[0]);
    }

    private <T> Set<ConstraintViolation<T>> validBeanParams(T bean) {
        return BEAN_VALIDATOR.validate(bean, new Class[0]);
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        BEAN_VALIDATOR = factory.getValidator();
        METHOD_VALIDATOR = factory.getValidator().forExecutables();
    }
}

