/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.config.cache;

import cn.com.duiba.cloud.biz.tool.config.cache.CacheProperties;
import cn.com.duiba.cloud.biz.tool.config.cache.RedisCacheManagerConfiguration;
import cn.com.duiba.cloud.biz.tool.utils.PropertiesUtil;
import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisAutoConfiguration;
import cn.hutool.core.lang.Assert;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@EnableCaching
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RedisOperations.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheAutoConfiguration
extends CachingConfigurerSupport {
    @Resource
    private RedisConnectionFactory factory;
    @Resource
    private CacheProperties cacheProperties;

    @Bean
    public CacheManager cacheManager() {
        Assert.notNull((Object)PropertiesUtil.getInstance().getProperty("spring.application.name"), (String)"\u5e94\u7528\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RedisCacheConfiguration defaultConfig = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(cacheName -> this.cacheProperties.getPrefixName().concat(":").concat(cacheName).concat(":")).disableCachingNullValues().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Hessian2SerializationRedisSerializer()));
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)this.factory);
        RedisCacheManagerConfiguration redisCacheManagerConfiguration = new RedisCacheManagerConfiguration(redisCacheWriter, defaultConfig);
        redisCacheManagerConfiguration.setTransactionAware(true);
        return redisCacheManagerConfiguration;
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return (target, method, params) -> {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getName()).append("|");
            sb.append(method.getName()).append("|");
            for (Object obj : params) {
                sb.append(null == obj ? "null" : obj.toString());
            }
            return sb.toString();
        };
    }
}

