/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.config.cache;

import cn.com.duibaboot.ext.autoconfigure.data.redis.DuibaRedisCondition;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisProperties;
import cn.hutool.core.util.StrUtil;
import javax.annotation.Resource;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RedissonClient.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedissonConfiguration {
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    @Resource
    private RedisProperties redisProperties;

    @Bean
    @Conditional(value={DuibaRedisCondition.class})
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redissonClient() {
        Config config = new Config();
        config.useSingleServer().setAddress(REDIS_PROTOCOL_PREFIX + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setPassword(StrUtil.isEmpty((CharSequence)this.redisProperties.getPassword()) ? null : this.redisProperties.getPassword());
        return Redisson.create((Config)config);
    }
}

