/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ListTool {
    public static <T> Triple<List<T>, List<Pair<T, T>>, List<T>> compare(List<T> existList, List<T> list, KeyGenerator<T> keyGenerator) {
        Map existSkuMap = existList.stream().collect(Collectors.toMap(keyGenerator::key, Function.identity(), (a, b) -> a));
        ArrayList<Pair> needUpdate = new ArrayList<Pair>();
        ArrayList<T> needCreate = new ArrayList<T>();
        HashSet<String> validIds = new HashSet<String>();
        for (T t : list) {
            String key = keyGenerator.key(t);
            Object exist = existSkuMap.get(key);
            if (exist == null) {
                needCreate.add(t);
                continue;
            }
            needUpdate.add(Pair.of(exist, t));
            validIds.add(key);
        }
        ArrayList needDelete = new ArrayList();
        for (Map.Entry entry : existSkuMap.entrySet()) {
            if (validIds.contains(entry.getKey())) continue;
            needDelete.add(entry.getValue());
        }
        return Triple.of(needCreate, needUpdate, needDelete);
    }

    @FunctionalInterface
    public static interface KeyGenerator<T> {
        public String key(T var1);
    }
}

