/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.function.ObjIntConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolUtil.class);

    public static <T> void execute(List<T> dataList, int concurrentCount, ExecutorService executorService, ObjIntConsumer<List<T>> taskConsumer) {
        int taskSize = dataList.size();
        if (taskSize < concurrentCount) {
            concurrentCount = taskSize;
        }
        int pageSize = (int)Math.floor((double)taskSize / (double)concurrentCount);
        CountDownLatch latch = new CountDownLatch(concurrentCount);
        for (int i = 0; i < concurrentCount; ++i) {
            int start = i * pageSize;
            int end = (i + 1) * pageSize;
            if (i + 1 == concurrentCount) {
                end = taskSize;
            }
            ArrayList tempList = new ArrayList(dataList.subList(start, end));
            executorService.execute(() -> {
                try {
                    taskConsumer.accept(tempList, start);
                }
                catch (Exception e) {
                    log.error("Thread Execute Error", (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("Latch await error", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

