package cn.com.duiba.cloud.biz.tool.config.cache;

import cn.com.duiba.cloud.biz.tool.constants.BaseConstant;
import cn.com.duiba.cloud.biz.tool.utils.PropertiesUtil;
import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import cn.hutool.core.lang.Assert;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.StringRedisSerializer;

import javax.annotation.Resource;

/**
 * spring cache配置
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/6 2:28 下午
 **/
@EnableCaching
@Configuration
@EnableConfigurationProperties(CacheProperties.class)
public class CacheAutoConfiguration extends CachingConfigurerSupport {
    @Resource
    private RedisConnectionFactory factory;

    @Bean
    @Override
    public CacheManager cacheManager() {
        Assert.notNull(PropertiesUtil.getInstance().getProperty("spring.application.name"), "应用名不能为空");
        RedisCacheConfiguration defaultConfig = RedisCacheConfiguration.defaultCacheConfig()
                .computePrefixWith(cacheName -> BaseConstant.CACHE.concat(cacheName).concat(":"))
                .disableCachingNullValues()
                .serializeKeysWith(RedisSerializationContext
                        .SerializationPair
                        .fromSerializer(new StringRedisSerializer()))
                .serializeValuesWith(RedisSerializationContext
                        .SerializationPair
                        .fromSerializer(new Hessian2SerializationRedisSerializer()));
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter(factory);
        RedisCacheManagerConfiguration redisCacheManagerConfiguration = new RedisCacheManagerConfiguration(redisCacheWriter, defaultConfig);
        redisCacheManagerConfiguration.setTransactionAware(true);
        return redisCacheManagerConfiguration;
    }

    @Bean
    @Override
    public KeyGenerator keyGenerator() {
        return (target, method, params) -> {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getName()).append("|");
            sb.append(method.getName()).append("|");
            for (Object obj : params) {
                sb.append(null == obj ? "null" : obj.toString());
            }
            return sb.toString();
        };
    }
}