package cn.com.duiba.cloud.biz.tool.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.message.ErrorMeta;

/**
 * bizException断言工具类 {@link BizException}
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 12:37 下午
 **/
public class Conditions {
    public static void expectFalse(boolean expression, ErrorMeta errorMeta) throws BizException {
        expectFalse(expression, errorMeta.getCode(), errorMeta.getDesc());
    }

    public static void expectFalse(boolean expression, String desc) throws BizException {
        expectFalse(expression, null, desc);
    }

    public static void expectFalse(boolean expression, String code, String desc) throws BizException {
        if (expression) {
            throw new BizException(desc).withCode(code);
        }
    }

    public static void expectAllTrue(ErrorMeta errorMeta, boolean... expressions) throws BizException {
        expectAllTrue(errorMeta.getCode(), errorMeta.getDesc(), expressions);
    }

    public static void expectAllTrue(String desc, boolean... expressions) throws BizException {
        expectAllTrue(null, desc, expressions);
    }

    public static void expectAllTrue(String code, String desc, boolean... expressions) throws BizException {
        for (boolean b : expressions) {
            expectTrue(b, code, desc);
        }
    }

    public static void expectTrue(boolean expression, ErrorMeta errorMeta) throws BizException {
        expectTrue(expression, errorMeta.getCode(), errorMeta.getDesc());
    }

    public static void expectTrue(boolean expression, String desc) throws BizException {
        expectTrue(expression, null, desc);
    }

    public static void expectTrue(boolean expression, String code, String desc) throws BizException {
        if (!expression) {
            throw new BizException(desc).withCode(code);
        }
    }

    public static <T> T expectNotNull(T reference, ErrorMeta errorMeta) throws BizException {
        return expectNotNull(reference, errorMeta.getCode(), errorMeta.getDesc());
    }

    public static <T> T expectNotNull(T reference, String desc) throws BizException {
        return expectNotNull(reference, null, desc);
    }

    public static <T> T expectNotNull(T reference, String code, String desc) throws BizException {
        if (reference == null) {
            throw new BizException(desc).withCode(code);
        } else {
            return reference;
        }
    }
}