package cn.com.duiba.cloud.biz.tool.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.message.ErrorMeta;
import cn.com.duiba.cloud.biz.tool.message.MessageCallBack;

/**
 * bizException断言工具类 {@link BizException}
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.3
 * @date 2021/11/20 12:37 下午
 * @since 0.0.3
 **/
public class Conditions {
    public static void expectFalse(boolean expression, ErrorMeta errorMeta) throws BizException {
        expectFalse(expression, errorMeta.getCode(), errorMeta.getDesc(), null);
    }

    public static void expectFalse(boolean expression, ErrorMeta errorMeta, MessageCallBack messageCallBack) throws BizException {
        expectFalse(expression, errorMeta.getCode(), errorMeta.getDesc(), messageCallBack);
    }

    public static void expectFalse(boolean expression, String desc) throws BizException {
        expectFalse(expression, null, desc, null);
    }

    public static void expectFalse(boolean expression, String desc, MessageCallBack messageCallBack) throws BizException {
        expectFalse(expression, null, desc, messageCallBack);
    }

    public static void expectFalse(boolean expression, String code, String desc, MessageCallBack messageCallBack) throws BizException {
        if (expression) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw new BizException(desc).withCode(code);
        }
    }

    public static void expectAllTrue(ErrorMeta errorMeta, boolean... expressions) throws BizException {
        expectAllTrue(errorMeta.getCode(), errorMeta.getDesc(), null, expressions);
    }

    public static void expectAllTrue(ErrorMeta errorMeta, MessageCallBack messageCallBack, boolean... expressions) throws BizException {
        expectAllTrue(errorMeta.getCode(), errorMeta.getDesc(), messageCallBack, expressions);
    }

    public static void expectAllTrue(String desc, boolean... expressions) throws BizException {
        expectAllTrue(null, desc, null, expressions);
    }

    public static void expectAllTrue(String desc, MessageCallBack messageCallBack, boolean... expressions) throws BizException {
        expectAllTrue(null, desc, messageCallBack, expressions);
    }

    public static void expectAllTrue(String code, String desc, MessageCallBack messageCallBack, boolean... expressions) throws BizException {
        for (boolean b : expressions) {
            expectTrue(b, code, desc, messageCallBack);
        }
    }

    public static void expectTrue(boolean expression, ErrorMeta errorMeta) throws BizException {
        expectTrue(expression, errorMeta.getCode(), errorMeta.getDesc(), null);
    }

    public static void expectTrue(boolean expression, ErrorMeta errorMeta, MessageCallBack messageCallBack) throws BizException {
        expectTrue(expression, errorMeta.getCode(), errorMeta.getDesc(), messageCallBack);
    }

    public static void expectTrue(boolean expression, String desc) throws BizException {
        expectTrue(expression, null, desc, null);
    }

    public static void expectTrue(boolean expression, String desc, MessageCallBack messageCallBack) throws BizException {
        expectTrue(expression, null, desc, messageCallBack);
    }

    public static void expectTrue(boolean expression, String code, String desc, MessageCallBack messageCallBack) throws BizException {
        if (!expression) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw new BizException(desc).withCode(code);
        }
    }

    public static <T> T expectNotNull(T reference, ErrorMeta errorMeta) throws BizException {
        return expectNotNull(reference, errorMeta.getCode(), errorMeta.getDesc(), null);
    }

    public static <T> T expectNotNull(T reference, ErrorMeta errorMeta, MessageCallBack messageCallBack) throws BizException {
        return expectNotNull(reference, errorMeta.getCode(), errorMeta.getDesc(), messageCallBack);
    }

    public static <T> T expectNotNull(T reference, String desc) throws BizException {
        return expectNotNull(reference, null, desc, null);
    }

    public static <T> T expectNotNull(T reference, String desc, MessageCallBack messageCallBack) throws BizException {
        return expectNotNull(reference, null, desc, messageCallBack);
    }

    public static <T> T expectNotNull(T reference, String code, String desc, MessageCallBack messageCallBack) throws BizException {
        if (reference == null) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw new BizException(desc).withCode(code);
        } else {
            return reference;
        }
    }
}