package cn.com.duiba.cloud.biz.tool.config.i18n;

import cn.com.duiba.cloud.biz.tool.aop.i18n.I18nAspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

/**
 * 国际化消息自动装配
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/29 12:58 下午
 * @since 0.0.1
 **/
@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(I18nProperties.class)
@ConditionalOnProperty(name = "duiba.i18n.enable", havingValue = "true")
public class I18nAutoConfiguration {
    @Bean
    public I18nAspect i18nAspect() {
        return new I18nAspect();
    }
}