package cn.com.duiba.cloud.biz.tool;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * TODO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/29 2:53 下午
 * @since 0.0.1
 **/
public class AppContext {
    private static ThreadLocal<HttpServletRequest> request = new InheritableThreadLocal<>();

    /**
     * 设置request，保存在ThreadLocal中
     *
     * @param req request
     */
    public static void setRequest(HttpServletRequest req) {
        request.set(req);
    }

    /**
     * 获取HttpServletRequest
     *
     * @return HttpServletRequest
     */
    public static HttpServletRequest getRequest() {
        HttpServletRequest req = request.get();
        if (req == null) {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                req = ((ServletRequestAttributes) attributes).getRequest();
            }
        }
        return req;
    }

    /**
     * 清除数据，防止内存泄露。
     */
    public static void clean() {
        request.remove();
    }
}