package cn.com.duiba.cloud.biz.tool.aop.validation;

import cn.com.duiba.boot.exception.BizException;
import cn.hutool.core.collection.CollUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.List;
import java.util.Set;

/**
 * remote接口参数校验的切面
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.5
 * @date 2021/12/13 5:54 下午
 * @since 0.0.5
 **/
@Aspect
public class ValidationAspect {
    private static final Validator VALIDATOR;

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        VALIDATOR = factory.getValidator();
    }

    @Pointcut("@within(cn.com.duiba.cloud.biz.tool.aop.validation.Validation) || @annotation(cn.com.duiba.cloud.biz.tool.aop.validation.Validation)")
    public void validate() {

    }

    @Before("validate()")
    public void before(JoinPoint point) throws BizException {
        Object[] objects = point.getArgs();
        for (Object object : objects) {
            if (object instanceof List) {
                for (int i = 0; i < ((List<?>) object).size(); i++) {
                    handle(((List<?>) object).get(i));
                }
            } else {
                handle(object);
            }
        }
    }

    private void handle(Object object) throws BizException {
        Set<ConstraintViolation<Object>> set = VALIDATOR.validate(object);
        if (CollUtil.isNotEmpty(set)) {
            ConstraintViolation<Object> oneError = set.iterator().next();
            String errorMsg = oneError.getMessage();
            throw new BizException(errorMsg);
        }
    }
}