package cn.com.duiba.cloud.biz.tool.message;

import cn.com.duiba.boot.exception.BizException;
import lombok.Setter;

import java.util.Locale;
import java.util.Objects;

/**
 * 错误元对象
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 12:36 下午
 **/
@Setter
public class ErrorMeta implements Error<String> {
    private String code;
    private String msg;
    private String isvModule;

    public ErrorMeta(String isvModule, String code, String msg) {
        super();
        Objects.requireNonNull(isvModule, "isvModule不能为null");
        Objects.requireNonNull(code, "code不能为null");
        Objects.requireNonNull(msg, "msg不能为null");
        this.isvModule = isvModule;
        this.code = code;
        this.msg = msg;
    }

    public ErrorMeta(String code, String msg) {
        super();
        this.code = code;
        this.msg = msg;
    }

    @Override
    public String getMsg() {
        return msg;
    }

    @Override
    public String getCode() {
        return code;
    }

    public String getIsvModule() {
        return isvModule;
    }

    public BizException getException(Object... params) {
        return this.getException(Locale.SIMPLIFIED_CHINESE, params);
    }

    public BizException getException(Locale locale, Object... params) {
        Error<String> error = ErrorFactory.getError(this, locale, params);
        return new BizException(error.getMsg()).withCode(error.getCode());
    }
}