/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.aop.validation;

import cn.com.duiba.boot.exception.BizException;
import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class ValidationAspect {
    private static final Validator VALIDATOR;

    @Pointcut(value="@within(cn.com.duiba.cloud.biz.tool.aop.validation.Validation) || @annotation(cn.com.duiba.cloud.biz.tool.aop.validation.Validation)")
    public void validate() {
    }

    @Before(value="validate()")
    public void before(JoinPoint point) throws BizException {
        Object[] objects;
        for (Object object : objects = point.getArgs()) {
            if (object instanceof List) {
                for (int i = 0; i < ((List)object).size(); ++i) {
                    this.handle(((List)object).get(i));
                }
                continue;
            }
            this.handle(object);
        }
    }

    private void handle(Object object) throws BizException {
        Set set = VALIDATOR.validate(object, new Class[0]);
        if (CollUtil.isNotEmpty((Collection)set)) {
            ConstraintViolation oneError = (ConstraintViolation)set.iterator().next();
            String errorMsg = oneError.getMessage();
            throw new BizException(errorMsg);
        }
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        VALIDATOR = factory.getValidator();
    }
}

