/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.aop.i18n;

import cn.com.duiba.cloud.biz.tool.AppContext;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class I18nAspect {
    private static final Logger log = LoggerFactory.getLogger(I18nAspect.class);

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController) || @within(org.springframework.stereotype.Controller)")
    public void i18n() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="i18n()")
    public Object doAroundAdvice(ProceedingJoinPoint point) throws Throwable {
        HttpServletRequest request;
        try {
            request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        }
        catch (Exception e) {
            return point.proceed();
        }
        try {
            AppContext.setRequest(request);
            Object object = point.proceed();
            return object;
        }
        finally {
            AppContext.clean();
        }
    }
}

