/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.utils;

import cn.com.duiba.boot.exception.BizException;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.ObjIntConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolUtil.class);
    private static ExecutorService executorService = null;
    private static final Integer WARNING_QUEUE_SIZE = 200000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getPool() throws BizException {
        if (null == executorService || executorService.isTerminated()) {
            Class<ThreadPoolUtil> clazz = ThreadPoolUtil.class;
            synchronized (ThreadPoolUtil.class) {
                if (null == executorService) {
                    executorService = new ThreadPoolExecutor(50, 100, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(WARNING_QUEUE_SIZE), new ThreadFactoryBuilder().setNameFormat("duiba-thread-%d").build());
                }
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        } else if (((ThreadPoolExecutor)executorService).getQueue().size() >= WARNING_QUEUE_SIZE) {
            throw new BizException("\u5f53\u524d\u7ebf\u7a0b\u6c60\u5f85\u6267\u884c\u5185\u5bb9\u8f83\u591a\uff0c\u4e3a\u4e86\u7cfb\u7edf\u6b63\u5e38\u8fd0\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5~");
        }
        return executorService;
    }

    public static <T> void execute(List<T> dataList, int concurrentCount, ObjIntConsumer<List<T>> taskConsumer) {
        int taskSize = dataList.size();
        if (taskSize < concurrentCount) {
            concurrentCount = taskSize;
        }
        int pageSize = (int)Math.floor((double)taskSize / (double)concurrentCount);
        CountDownLatch latch = new CountDownLatch(concurrentCount);
        for (int i = 0; i < concurrentCount; ++i) {
            int start = i * pageSize;
            int end = (i + 1) * pageSize;
            if (i + 1 == concurrentCount) {
                end = taskSize;
            }
            ArrayList tempList = new ArrayList(dataList.subList(start, end));
            executorService.execute(() -> {
                try {
                    taskConsumer.accept(tempList, start);
                }
                catch (Exception e) {
                    log.error("Thread Execute Error", (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (Exception e) {
            log.error("Latch await error", (Throwable)e);
        }
    }
}

