package cn.com.duiba.cloud.biz.tool.config.datasource;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

import javax.sql.DataSource;

/**
 * 兑吧数据源自动装配
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-25 20:29
 * @since 0.1.0
 **/
@Configuration(proxyBeanMethods = false)
@ConditionalOnClass(DataSource.class)
@AutoConfigureBefore(DataSourceAutoConfiguration.class)
public class DuibaDataSourceAutoConfiguration {
    @Configuration
    public static class DuibaDataSourceMonitorAutoConfiguration {
        @EventListener(MainContextRefreshedEvent.class)
        public void initListener(MainContextRefreshedEvent event) {
            ApplicationContext applicationContext = event.getApplicationContext();
            new DuibaDataSourceMonitor().startRun(applicationContext);
        }
    }
}
