/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.config.datasource;

import cn.com.duibaboot.ext.autoconfigure.perftest.datasource.PerfTestRoutingDataSource;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.google.common.collect.Maps;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;

public class DuibaDataSourceMonitor
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DuibaDataSourceMonitor.class);
    private boolean started = false;
    private Map<String, DataSource> dataSourceMap;
    private ExecutorService singleThreadPool;
    private static final int THRESHOLD_VALUE = 3;
    private static final String THREAD_NAME_PREFIX = "duiba-datasource-monitor-thread-";
    private static final String FORMAT_ONE = "datasource [%s]'s connectionPool is too full,max:%d,busy:%d,idle:%d";
    private static final boolean HIKARI_MONITOR_EXISTS;
    private static final boolean SHARDING_CLASS_EXISTS;
    private static final boolean DYNAMIC_CLASS_EXISTS;

    public synchronized void startRun(ApplicationContext applicationContext) {
        if (this.started) {
            log.warn("duiba datasource monitor already started, please don't call start again");
            return;
        }
        Map beansOfType = applicationContext.getBeansOfType(DataSource.class);
        this.dataSourceMap = this.wrapperDatasourceMap(beansOfType);
        if (this.dataSourceMap.isEmpty()) {
            return;
        }
        this.singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new ThreadFactoryBuilder().setNamePrefix(THREAD_NAME_PREFIX).build());
        this.singleThreadPool.execute(this::scanDataSources);
        this.started = true;
    }

    private Map<String, DataSource> wrapperDatasourceMap(Map<String, DataSource> beansOfType) {
        HashMap dsMap = Maps.newHashMap();
        for (Map.Entry<String, DataSource> entry : beansOfType.entrySet()) {
            DataSource ds = entry.getValue();
            if (SHARDING_CLASS_EXISTS && ds instanceof ShardingSphereDataSource) {
                Map metaDataMap = ((ShardingSphereDataSource)ds).getContextManager().getMetaDataContexts().getMetaDataMap();
                for (Map.Entry shardingMetaDataEntry : metaDataMap.entrySet()) {
                    Map shardingMetaDataSource = ((ShardingSphereMetaData)shardingMetaDataEntry.getValue()).getResource().getDataSources();
                    for (Map.Entry dataSourceEntry : shardingMetaDataSource.entrySet()) {
                        if (dsMap.containsKey(dataSourceEntry.getKey())) continue;
                        dsMap.put(dataSourceEntry.getKey(), dataSourceEntry.getValue());
                    }
                }
                continue;
            }
            if (!DYNAMIC_CLASS_EXISTS || !(ds instanceof DynamicRoutingDataSource)) continue;
            Map dataSources = ((DynamicRoutingDataSource)ds).getDataSources();
            for (Map.Entry dynamicRoutingEntry : dataSources.entrySet()) {
                if (!(dynamicRoutingEntry.getValue() instanceof ItemDataSource) || dsMap.containsKey(dynamicRoutingEntry.getKey())) continue;
                dsMap.put(dynamicRoutingEntry.getKey(), ((ItemDataSource)dynamicRoutingEntry.getValue()).getDataSource());
            }
        }
        return dsMap;
    }

    private void scanDataSources() {
        do {
            try {
                for (Map.Entry<String, DataSource> entry : this.dataSourceMap.entrySet()) {
                    DataSource ds = entry.getValue();
                    if (ds instanceof PerfTestRoutingDataSource) continue;
                    this.scanDataSource(entry.getKey(), ds);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        } while (!Thread.currentThread().isInterrupted());
    }

    private void scanDataSource(String key, DataSource ds) {
        DataSourceMonitorBO dataSourceMonitorBO;
        if (this.isValid(ds) && ds instanceof HikariDataSource && null != (dataSourceMonitorBO = this.wrapperMonitorBO(ds))) {
            this.warnIfTooFull(key, dataSourceMonitorBO);
        }
    }

    private void warnIfTooFull(String key, DataSourceMonitorBO dataSourceMonitorBO) {
        int numIdleConnections = dataSourceMonitorBO.getNumAllocated() - dataSourceMonitorBO.getNumActive();
        log.error(String.format(FORMAT_ONE, key, dataSourceMonitorBO.getMaxTotal(), dataSourceMonitorBO.getNumActive(), numIdleConnections));
        if (dataSourceMonitorBO.getNumActive() >= 3 && dataSourceMonitorBO.getNumAllocated() >= dataSourceMonitorBO.getMaxTotal() - 3 && dataSourceMonitorBO.getNumActive() >= dataSourceMonitorBO.getNumAllocated() - 3) {
            log.error(String.format(FORMAT_ONE, key, dataSourceMonitorBO.getMaxTotal(), dataSourceMonitorBO.getNumActive(), numIdleConnections));
        }
    }

    private DataSourceMonitorBO wrapperMonitorBO(DataSource ds) {
        HikariDataSource hikariDs;
        HikariPoolMXBean hikariBean;
        if (HIKARI_MONITOR_EXISTS && ds instanceof HikariDataSource && null != (hikariBean = (hikariDs = (HikariDataSource)ds).getHikariPoolMXBean())) {
            int numIdleConnections = hikariBean.getIdleConnections();
            int numActiveConnections = hikariBean.getActiveConnections();
            int maxTotal = ((HikariDataSource)ds).getMaximumPoolSize();
            int threadsAwaitingConnection = hikariBean.getThreadsAwaitingConnection();
            return new DataSourceMonitorBO(numActiveConnections, numActiveConnections + numIdleConnections, maxTotal, threadsAwaitingConnection);
        }
        return null;
    }

    private boolean isValid(DataSource ds) {
        if (ds != null) {
            return ds instanceof HikariDataSource && !((HikariDataSource)ds).isClosed();
        }
        return false;
    }

    public void destroy() {
        if (this.singleThreadPool != null) {
            ThreadPoolExecutor pool = (ThreadPoolExecutor)this.singleThreadPool;
            log.info("\u5173\u95eddataSource\u76d1\u63a7\u7ebf\u7a0b\u6c60,taskCount:{},completedCount:{}", (Object)pool.getTaskCount(), (Object)pool.getCompletedTaskCount());
            pool.shutdown();
        }
    }

    static {
        boolean hikariMonitorExists = false;
        boolean shardingClassExists = false;
        boolean dynamicClassExists = false;
        try {
            HikariDataSource.class.getDeclaredMethod("getHikariPoolMXBean", new Class[0]);
            hikariMonitorExists = true;
        }
        catch (NoSuchMethodException e) {
            log.warn("\u8bf7\u628ahikari\u5347\u7ea7\u5230\u6700\u65b0\u7248\uff0c\u5426\u5219\u65e0\u6cd5\u76d1\u63a7\u8fde\u63a5\u6c60\u4f7f\u7528\u6570\u636e");
        }
        try {
            Class.forName("com.baomidou.dynamic.datasource.DynamicRoutingDataSource");
            dynamicClassExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource");
            shardingClassExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HIKARI_MONITOR_EXISTS = hikariMonitorExists;
        SHARDING_CLASS_EXISTS = shardingClassExists;
        DYNAMIC_CLASS_EXISTS = dynamicClassExists;
    }

    public static class DataSourceMonitorBO {
        private Integer numActive;
        private Integer numAllocated;
        private Integer maxTotal;
        private Integer threadsAwaitingConnection;

        public Integer getNumActive() {
            return this.numActive;
        }

        public Integer getNumAllocated() {
            return this.numAllocated;
        }

        public Integer getMaxTotal() {
            return this.maxTotal;
        }

        public Integer getThreadsAwaitingConnection() {
            return this.threadsAwaitingConnection;
        }

        public void setNumActive(Integer numActive) {
            this.numActive = numActive;
        }

        public void setNumAllocated(Integer numAllocated) {
            this.numAllocated = numAllocated;
        }

        public void setMaxTotal(Integer maxTotal) {
            this.maxTotal = maxTotal;
        }

        public void setThreadsAwaitingConnection(Integer threadsAwaitingConnection) {
            this.threadsAwaitingConnection = threadsAwaitingConnection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSourceMonitorBO)) {
                return false;
            }
            DataSourceMonitorBO other = (DataSourceMonitorBO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$numActive = this.getNumActive();
            Integer other$numActive = other.getNumActive();
            if (this$numActive == null ? other$numActive != null : !((Object)this$numActive).equals(other$numActive)) {
                return false;
            }
            Integer this$numAllocated = this.getNumAllocated();
            Integer other$numAllocated = other.getNumAllocated();
            if (this$numAllocated == null ? other$numAllocated != null : !((Object)this$numAllocated).equals(other$numAllocated)) {
                return false;
            }
            Integer this$maxTotal = this.getMaxTotal();
            Integer other$maxTotal = other.getMaxTotal();
            if (this$maxTotal == null ? other$maxTotal != null : !((Object)this$maxTotal).equals(other$maxTotal)) {
                return false;
            }
            Integer this$threadsAwaitingConnection = this.getThreadsAwaitingConnection();
            Integer other$threadsAwaitingConnection = other.getThreadsAwaitingConnection();
            return !(this$threadsAwaitingConnection == null ? other$threadsAwaitingConnection != null : !((Object)this$threadsAwaitingConnection).equals(other$threadsAwaitingConnection));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSourceMonitorBO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $numActive = this.getNumActive();
            result = result * 59 + ($numActive == null ? 43 : ((Object)$numActive).hashCode());
            Integer $numAllocated = this.getNumAllocated();
            result = result * 59 + ($numAllocated == null ? 43 : ((Object)$numAllocated).hashCode());
            Integer $maxTotal = this.getMaxTotal();
            result = result * 59 + ($maxTotal == null ? 43 : ((Object)$maxTotal).hashCode());
            Integer $threadsAwaitingConnection = this.getThreadsAwaitingConnection();
            result = result * 59 + ($threadsAwaitingConnection == null ? 43 : ((Object)$threadsAwaitingConnection).hashCode());
            return result;
        }

        public String toString() {
            return "DuibaDataSourceMonitor.DataSourceMonitorBO(numActive=" + this.getNumActive() + ", numAllocated=" + this.getNumAllocated() + ", maxTotal=" + this.getMaxTotal() + ", threadsAwaitingConnection=" + this.getThreadsAwaitingConnection() + ")";
        }

        public DataSourceMonitorBO(Integer numActive, Integer numAllocated, Integer maxTotal, Integer threadsAwaitingConnection) {
            this.numActive = numActive;
            this.numAllocated = numAllocated;
            this.maxTotal = maxTotal;
            this.threadsAwaitingConnection = threadsAwaitingConnection;
        }
    }
}

