/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.config.datasource;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.provider.AbstractDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={DynamicRoutingDataSource.class, ShardingSphereDataSource.class})
@AutoConfigureBefore(value={DynamicDataSourceAutoConfiguration.class})
public class DuibaDynamicDataSourceAutoConfiguration {
    public static final String SHARDING_DATA_SOURCE_NAME = "sharding";
    @Resource
    private DynamicDataSourceProperties properties;
    @Resource
    private ShardingSphereDataSource shardingSphereDataSource;

    @Bean
    @ConditionalOnClass(value={DynamicRoutingDataSource.class, ShardingSphereDataSource.class})
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        return new AbstractDataSourceProvider(){

            public Map<String, DataSource> loadDataSources() {
                HashMap dataSourceMap = Maps.newHashMap();
                dataSourceMap.put(DuibaDynamicDataSourceAutoConfiguration.SHARDING_DATA_SOURCE_NAME, DuibaDynamicDataSourceAutoConfiguration.this.shardingSphereDataSource);
                Map metaDataMap = DuibaDynamicDataSourceAutoConfiguration.this.shardingSphereDataSource.getContextManager().getMetaDataContexts().getMetaDataMap();
                for (Map.Entry entry : metaDataMap.entrySet()) {
                    dataSourceMap.putAll(((ShardingSphereMetaData)entry.getValue()).getResource().getDataSources());
                }
                return dataSourceMap;
            }
        };
    }

    @Bean
    @Primary
    public DataSource dataSource() {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(this.properties.getPrimary());
        dataSource.setStrict(this.properties.getStrict());
        dataSource.setStrategy(this.properties.getStrategy());
        dataSource.setP6spy(this.properties.getP6spy());
        dataSource.setSeata(this.properties.getSeata());
        return dataSource;
    }
}

