package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuStatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.UserBiz;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:36 下午
 */
@Getter
@Setter
public class SpuDto extends AbstractGoodsDto implements UserBiz {
    private static final long serialVersionUID = 1L;
    /**
     * 品牌id
     */
    private Long brandId;
    /**
     * 商品类型(1:实物,2:优惠券:3:充值,4:权益)
     *
     * @see SpuTypeEnum
     */
    private Integer spuType;
    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    private Integer userType;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 商品状态(1:正常商品, 2:草稿箱商品, 3:审核中,4:审核失败)
     *
     * @see SpuStatusEnum
     */
    private Integer spuStatus;
    /**
     * 叶子类目
     */
    private Long leafCategoryId;

    /**
     * 是否删除(0:未删除,1:已删除)
     */
    private Integer isDeleted;


    /**
     * spuID或skuID
     */
    @Override
    public Long getGeneralId() {
        return getId();
    }

    /**
     * /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    @Override
    public Integer getGeneralType() {
        return GeneralTypeEnum.SPU.getGeneralType();
    }

    public boolean selfSpu(CurTenantParam param) {
        return Objects.equals(this.getUserType(), param.getCurUserType())
                && Objects.equals(this.getUserId(), param.getCurUserId());
    }

}
