package cn.com.duiba.cloud.duiba.goods.center.api.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.BaseEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/24 14:25
 */
public class EnumUtil implements Serializable {
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) throws BizException {
        System.out.println(EnumUtil.getByCode(SpuTypeEnum.class, 1));
        System.out.println(EnumUtil.getByCode(SpuTypeEnum.class, null));
        System.out.println(EnumUtil.getByCode(SpuTypeEnum.class, 99));
    }

    public static <E extends BaseEnum<T>, T> Optional<E> getByCode(Class<E> enumClass, T enumTag) {
        if (enumTag == null) {
            return Optional.empty();
        }
        for (E each : enumClass.getEnumConstants()) {
            if (Objects.equals(enumTag, each.getEnumTag())) {
                return Optional.of(each);
            }
        }
        return Optional.empty();
    }
}
