package cn.com.duiba.cloud.duiba.goods.center.api.param.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 商品列表搜索
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:58 下午
 */
@Getter
@Setter
public class GoodsQueryParam extends CurTenantParam {
    private static final long serialVersionUID = 2280565412001413219L;

    /**
     * 是否删除(0:未删除,1:已删除)
     */
    private Integer isDeleted = 0;

    /**
     * 商品
     */
    private Long spuId;
    private String fuzzySpuName;

    /**
     * 租户类型和租户Id
     */
    private Integer userType;
    private Long userId;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 品牌id
     */
    private List<Long> brandIds;

    /**
     * 叶子类目
     */
    private List<Long> leafCategoryIds;


    /**
     * 商品分组Id
     *
     * @param args
     */
    private List<Long> itemClassifyIds;

}
